#!/usr/bin/env bash

# Change static/fonts/* to whereever the fonts are
# Change BASEURL to the URL path in your website

BASEURL="/static/"
for font in static/fonts/*; do
        fontfamily=$(fc-scan $font | grep family: | cut -d\" -f2 | tr '\n' '    ' | cut -d"     " -f1)
        fontstyle=$(fc-scan $font | grep style: | cut -d\" -f2 | tr '\n' ' ')
        fontformat=$(fc-scan $font | grep fontformat: | cut -d\" -f2)
        fontfile="$(basename $font)"
        printf "@font-face {\n\tfont-family: \"$fontfamily\";\n\tfont-style:\"$fontstyle\";\n\tsrc: url(\"$BASEURL$fontfile\");\n}\n"
done
